#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// newton-rhapson LissajousMod01.fsh  by   asiermarzo
//https://www.shadertoy.com/view/tsSfRG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define sLenght(a) dot((a),(a))

vec2 cInv(vec2 c){
	float sl = dot(c,c);
	return vec2(c.x / sl, -c.y / sl);
}

vec2 cMul(vec2 a, vec2 b){
	vec4 t = a.xyxy * b.xyyx;
	return vec2(t.x - t.y, t.z + t.w);
}

//void mainImage(out vec4 fragColor, in vec2 fragCoord)
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float zoom = (sin(iTime/4.0)+1.0) * 8.0 + 1.0;
    vec2 p = -(zoom/2.0) + zoom * fragCoord.xy / iResolution.xy;
    p.x *= iResolution.x/iResolution.y;
	
	float t = iTime/2.0;
	
	//setting roots of a third grade poly using a Lissajous curve
    vec2 root1 = vec2(sin(t + 0.00000000) , sin(2.0 * t + 0.00000000));
	vec2 root2 = vec2(sin(t + 2.09439510) , sin(2.0 * t + 2.09439510));
	vec2 root3 = vec2(sin(t + 4.18879020) , sin(2.0 * t + 4.18879020));
	
	const int maxIters = 16;
	float tolerance = 1e-8;
	vec2 r1,r2,r3;
	vec2 prevP = p;
	float iters = 0.0;
	
	r1 = p-root1;
	r2 = p-root2;
	r3 = p-root3;

	for(int iterations = 0; iterations < maxIters; iterations++ ){
		prevP = p;
		//newton-rhapson method iteration
		p = p - cInv( cInv(r1) + cInv(r2) + cInv(r3) );
		
		//check how near we are from the nearest root
		r1 = p-root1;
		r2 = p-root2;
		r3 = p-root3;
		if (min(sLenght(r1),min(sLenght(r2),sLenght(r3))) < tolerance ) {break;}
		iters += 1.0;
	}
	float co = iters;
	
	//the code could be more compact but repeating code makes changing the gradients easier
	float l1 = length(p-root1);
	float l2 = length(p-root2);
	float l3 = length(p-root3);
	float dist0,dist1;
	float tol = log(tolerance);
    if (l1 <= l2 && l1 <= l3){
		dist0 = log(sLenght(prevP-root1));
		dist1 = log(sLenght(p-root1));
		if (dist1 < tol && dist0 > tol) { co += (tol - dist0) / (dist1 - dist0); }
		co = clamp(co/float(maxIters),0.0,1.0);
		
		//gradient for root1
		fragColor = vec4(
			0.5+0.89*cos(6.2831855*co+0.0),
			0.5+0.48000002*cos(25.132742*co+2.0734513),
			0.5+0.38*cos(50.265484*co+4.1469026),
			1.0);
			
	}else if (l2 <= l1 && l2 <= l3){
		dist0 = log(sLenght(prevP-root2));
		dist1 = log(sLenght(p-root2));
		if (dist1 < tol && dist0 > tol) { co += (tol - dist0) / (dist1 - dist0); }
		co = clamp(co/float(maxIters),0.0,1.0);
		
		//gradient for root2 
		fragColor = vec4(
			0.5+0.6*cos(2.0106194*co+-1.5079645),
			0.5+1.0*cos(4.5867257*co+2.576106),
			0.5+0.82*cos(3.015929*co+2.3247786),
			1.0);
			
	}else if (l3 <= l2 && l3 <= l1){
		dist0 = log(sLenght(prevP-root3));
		dist1 = log(sLenght(p-root3));
		if (dist1 < tol && dist0 > tol) { co += (tol - dist0) / (dist1 - dist0); }
		co = clamp(co/float(maxIters),0.0,1.0);
		
		//gradient for root3 
		fragColor = vec4( .5+.5*cos(6.2831*co+0.0),
                         .5+.5*cos(6.2831*co+0.4),
                         .5+.5*cos(6.2831*co+0.7),
                         1.0 );
						 
	}else{
		fragColor = vec4(0.0 , 0.0, 0.0, 1.0 );
	}
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

